<?php defined("SYSPATH") or die("No direct script access.");

class Admin_slideshowex_Controller extends Admin_Controller {

  public function index() {
    $view = new Admin_View("admin.html");
    $view->content = new View("admin_slideshowex.html");
    $view->content->form = $this->_get_setting_form();
    $view->content->help = $this->get_edit_form_help();
    print $view;
  }

  public function save() {
    access::verify_csrf();

    $form = $this->_get_setting_form();
    if ($form->validate()):
      $slideshow_type = $form->g_admin_slideshow->slideshow_type->value;
      $max_scale = $form->g_admin_slideshow->max_scale->value;
      $width = $form->g_admin_slideshow->width->value;
      $height = $form->g_admin_slideshow->height->value;

      if ($slideshow_type == "default"):
        module::clear_var("slideshow", "type");
      else:
        module::set_var("slideshow", "type", $slideshow_type);
      endif;   

      module::set_var("slideshow", "max_scale", $max_scale);

      if ($width == 730):
        module::clear_var("slideshow", "width");
      else:
        module::set_var("slideshow", "width", $width);
      endif;   

      if ($height == 460):
        module::clear_var("slideshow", "height");
      else:
        module::set_var("slideshow", "height", $height);
      endif;   

      message::success("Settings have been Saved.");
      url::redirect("admin/slideshowex");
    endif;

    $view = new Admin_View("admin.html");
    $view->content = new View("admin_slideshowex.html");
    $view->content->form = $form;
    $view->content->help = $this->get_edit_form_help();
    print $view;
  }

  private function _get_setting_form() {
    $form = new Forge("admin/slideshowex/save", "", "post", array("id" => "g-admin-slideshow-form"));
    $group = $form->group("g_admin_slideshow")->label(t("Settings"));
    $group->dropdown("slideshow_type")
      ->label(t("Slideshow Type"))
      ->options(array("default" => t("Cooliris (Mini)"), "wall" => t("Cooliris (Wall)"), "page" => t("Cooliris (Embeded)")))
      ->selected(module::get_var("slideshow", "type"));
    $group->input("max_scale")
      ->label(t("Max Scale"))
      ->rules("required|valid_digit")
      ->error_messages("required", t("You must enter a number"))
      ->error_messages("valid_digit", t("You must enter a number"))
      ->value(module::get_var("slideshow", "max_scale", 0));
    $group->input("width")
      ->label(t("Slideshow Width"))
      ->rules("required|valid_digit")
      ->error_messages("required", t("You must enter a number"))
      ->error_messages("valid_digit", t("You must enter a number"))
      ->value(module::get_var("slideshow", "width", 730));
    $group->input("height")
      ->label(t("Slideshow Height"))
      ->rules("required|valid_digit")
      ->error_messages("required", t("You must enter a number"))
      ->error_messages("valid_digit", t("You must enter a number"))
      ->value(module::get_var("slideshow", "height", 460));
      
    $form->submit("")->value(t("Save"));
    return $form;
  }

  protected function get_edit_form_help() {
    $help = '<fieldset>';
    $help .= '<legend>Help</legend><ul>';
    $help .= '<li><h3>Settings</h3>
      <p>Select Slideshow type: Cooliris (Mini), Cooliris (3D Wall), Cooliris (Embeded).</p>
      </li>';

    $help .= '</ul></fieldset>';
    return $help;
  }
}
