<?php defined("SYSPATH") or die("No direct script access.");

class SlideshowEx_event_Core {

  static function pre_deactivate($data) {
    if ($data->module == "rss") {
      $data->messages["warn"][] = t("The Slideshow module requires the RSS module.");
    }
  }

  static function deactivate() {
    site_status::clear("slideshow_config");
  }

  static function admin_menu($menu, $theme) {
    $menu
      ->get("settings_menu")
      ->append(Menu::factory("link")
               ->id("slideshow")
               ->label(t("Slideshow Ex"))
               ->url(url::site("admin/slideshowex")));
  }

  static function module_change($changes) {
    if (!module::is_active("rss") || in_array("rss", $changes->deactivate)) {
      site_status::warning(
        t("The Slideshow module requires the RSS module.  " .
          "<a href=\"%url\">Activate the RSS module now</a>",
          array("url" => html::mark_clean(url::site("admin/modules")))),
        "slideshow_needs_rss");
    } else {
      site_status::clear("slideshow_needs_rss");
    }
  }

  private static function _add_link($menu, $theme) {
    $max_scale = module::get_var("slideshow", "max_scale", 0);
    $slideshow_type = module::get_var("slideshow", "type", "default");

    switch ($slideshow_type) {
      case "wall":
        $link = "javascript:PicLensLite.start({maxScale:0,feedUrl:'" . self::_feed_url($theme) . "'})";
        break;
      case "page":
        $link = url::site("slideshowex/view_slideshow?rss=") . url::site(self::_feed_url($theme));
        break;
      default:
        $link = "javascript:cooliris.embed.show({maxScale:$max_scale,feed:'" . self::_feed_url($theme) . "'})";
        break;
    }

    if ($link) {
      $menu->append(Menu::factory("link")
                    ->id("slideshow")
                    ->label(t("View slideshow"))
                    ->url($link)
                    ->css_id("g-slideshow-link"));
    }
  }

  static function album_menu($menu, $theme) {
    if ($theme->item()->descendants_count(array(array("type", "=", "photo")))):
      self::_add_link($menu, $theme);
    endif;
  }

  static function photo_menu($menu, $theme) {
    self::_add_link($menu, $theme);
  }

  static function tag_menu($menu, $theme) {
    self::_add_link($menu, $theme);
  }

  private static function _feed_url($theme) {
    if ($item = $theme->item()) {
      if (!$item->is_album()) {
        $item = $item->parent();
      }
      return rss::url("gallery/album/{$item->id}");
    } else {
      return rss::url("tag/tag/{$theme->tag()->id}");
    }
  }
}
