<?php defined("SYSPATH") or die("No direct script access.");
/**
 * Wibiya Integration Module
 * Copyright (C) 2011 Serguei Dosyukov
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
class Admin_wibiya_Controller extends Admin_Controller {

  public function index() {
    $view = new Admin_View("admin.html");
    $view->content = new View("admin_wibiya.html");
    $view->content->form = $this->_get_setting_form();
    $view->content->help = $this->_get_help_form();

    print $view;
  }

  public function save() {
    access::verify_csrf();

    $form = $this->_get_setting_form();
    if ($form->validate()) {
      $url = $form->configure_wibiya->url->value;

      $ok = true;
      if (empty($url)) {
        $form->configure_wibiya->url->add_error("invalid", 1);
        $ok = false;
      } else {
        module::set_var("wibiya", "url", $url);
      }

      if ($ok) {
        message::success("Wibiya 'Registration URL has been Saved.");
        url::redirect("admin/wibiya");
			}
    }

    $view = new Admin_View("admin.html");
    $view->content = new View("admin_wibiya.html");
    $view->content->form = $form;
    $view->content->help = $this->_get_help_form();
    print $view;
  }

  private function _get_setting_form() {
    $form = new Forge("admin/wibiya/save", "", "post", array("id" => "g-admin-configure-wibiya-form"));
    $group = $form->group("configure_wibiya")->label(t("Settings"));
    $group->input("url")->label(t("Wibiya Registration URL"))->value(module::get_var("wibiya", "url"));
    $group->url->error_messages("invalid", t("URL cannot be empty."));
    $group->submit("")->value(t("Save"));
    return $form;
  }

  private function _get_help_form() {
    $help  = '<fieldset>';
    $help .= '<legend>Help</legend><br />';
    $help .= "<p>" . t("Insert URL to JS provided from Wibiya Admin Section.") . "</p>";
    $help .= '</fieldset>';
    return $help;
  }
}
