<?php defined("SYSPATH") or die("No direct script access.");

class Admin_colorbox_Controller extends Admin_Controller {

  private $newline = false;

  private function save_item_state($statename, $value, $default) {
    $hash = module::get_var("colorbox", "settings");
    if (isset($hash)):
      $settings = unserialize($hash);
      if (($value) and ($value != $default)):
        $settings[$statename] = $value;
      else:
        if (isset($settings[$statename])):
          unset($settings[$statename]);
        endif;
      endif;
    else:
      $settings = array();
    endif;
    module::set_var("colorbox", "settings", serialize($settings));
  }

  private function read_item_state($statename, $default) {
    $hash = module::get_var("colorbox", "settings");
    if (isset($hash)):
      $settings = unserialize($hash);
      if (isset($settings[$statename])):
        return $settings[$statename];
      else:
        return $default;
      endif;
    else:
      return $default;
    endif;
  }

  private function write_line($Handle, $line) {
    if ($line):
      if ($this->newline):
        $prefix = ',';
      else:
        $prefix = ' ';
      endif;

      $this->newline = true;
      fwrite($Handle, "    " . $prefix . $line . "\n");
    endif;
  }

  private function write_setting($Handle, $name, $state, $default, $type) {
    if ($state != $default):
      switch ($type):
        case 1: // bool
          if ($state):
            $this->write_line($Handle, "'$name' : true");
          else:
            $this->write_line($Handle, "'$name' : false");
          endif;
          break;
        case 2: // int
          $this->write_line($Handle, "'$name' : $state");
          break;
        case 3: // string
          $this->write_line($Handle, "'$name' : '$state'");
          break;
        default:
          $this->write_line($Handle, "'$name' : $state");
      endswitch;
    endif;
  }

  public function index() {
    $view = new Admin_View("admin.html");
    $view->content = new View("admin_colorbox.html");
    $view->content->form = $this->_get_setting_form();
    $view->content->help = $this->get_edit_form_help();
    print $view;
  }

  public function save() {
    access::verify_csrf();

    $form = $this->_get_setting_form();
    if ($form->validate()):

      /* Read Form State ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
      $target           = $form->g_colorbox_appearance->target->value;
      $overlay_opacity  = $form->g_colorbox_appearance->overlay_opacity->value;

      $transition       = $form->g_colorbox_animation->transition->value;
      $slideshow_enable = $form->g_colorbox_animation->slideshow_enable->value;
      $slideshow_auto   = $form->g_colorbox_animation->slideshow_auto->value;
      $slideshow_speed  = $form->g_colorbox_animation->slideshow_speed->value;

      $closeOvClick     = $form->g_colorbox_behavior->close_o_click->value;
      $closeEsc         = $form->g_colorbox_behavior->close_e_click->value;
      $cyclic           = $form->g_colorbox_behavior->cyclic->value;

      /* Save Form State ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

      $this->save_item_state("target", $target, "a.g-sb-preview;a.g-fullsize-link");
      $this->save_item_state("overlay_opacity", $overlay_opacity, "0.85");
      
      $this->save_item_state("transition",  $transition, "default");
      $this->save_item_state("slideshow_enable", $slideshow_enable, FALSE);
      $this->save_item_state("slideshow_noauto", !$slideshow_auto, FALSE);
      $this->save_item_state("slideshow_speed",  $slideshow_speed, "2500");

      $this->save_item_state("noCloseOvClick", !$closeOvClick, FALSE);
      $this->save_item_state("noCloseEsc", !$closeEsc, FALSE);
      $this->save_item_state("noCyclic", !$cyclic, FALSE);

      $File = MODPATH . "colorbox/js/colorbox-init.js";
      $Handle = fopen($File, 'w');
      fwrite($Handle, "// ******* Auto-generated file. Please do not change. ***\n\n");
      fwrite($Handle, "$(document).ready(function() {\n");

      $targets = explode(";", $target);
      foreach($targets as $key => $value):
        $this->newline = false;
        fwrite($Handle, "  $(\"$value\").colorbox({\n");

        /* Default Settings */
        $this->write_setting($Handle, "maxWidth", "90%", "", 3);
        $this->write_setting($Handle, "maxHeight", "90%", "", 3);

        /* User Settings */  
        $this->write_setting($Handle, "opacity", $overlay_opacity, "0.85", 2);

        $this->write_setting($Handle, "transition", $transition, "default", 3);
        $this->write_setting($Handle, "slideshow", $slideshow_enable, FALSE, 1);
        $this->write_setting($Handle, "slideshowAuto", $slideshow_auto, TRUE, 1);
        $this->write_setting($Handle, "slideshowSpeed", $slideshow_speed, 2500, 2);

        $this->write_setting($Handle, "overlayClose", $closeOvClick, TRUE, 1);
        $this->write_setting($Handle, "escKey", $closeEsc, TRUE, 1);
        $this->write_setting($Handle, "loop", $cyclic, TRUE, 1);
        
        fwrite($Handle, "  });\n\n");
      endforeach;

      fwrite($Handle, "});\n");
      fclose($Handle);

      site_status::clear("colorbox_config");
      message::success("Settings have been Saved.");
      url::redirect("admin/colorbox");
    endif;

    $view = new Admin_View("admin.html");
    $view->content = new View("admin_colorbox.html");
    $view->content->form = $form;
    $view->content->help = $this->get_edit_form_help();
    print $view;
  }

  private function _get_setting_form() {
    $form = new Forge("admin/colorbox/save", "", "post", array("id" => "g-admin-colorbox-form", "class" => "form-inline"));

    $group = $form->group("g_colorbox_appearance")->label(t("Appearance Settings"));
    $group->input("target")
      ->label(t("Target (jQuery filter)"))
      ->rules("required")
      ->error_messages("required", t("You must enter a class/id/selector"))
      ->value($this->read_item_state("target", "a.g-sb-preview;a.g-fullsize-link"));
    $group->dropdown("overlay_opacity")
      ->label(t("Overlay Opacity (default: 0.8)"))
      ->options(array("0.01" => t("0 (transparent)"), "0.1" => "0.1", "0.2" => "0.2", "0.3" => "0.3", "0.4" => "0.4", "0.5" => "0.5", "0.6" => "0.6", "0.7" => "0.7", "0.85" => "0.8 (default)", "0.9" => "0.9", "1" => t("1 (opaque)")))
      ->selected($this->read_item_state("overlay_opacity", "0.85"));

    $group = $form->group("g_colorbox_animation")->label(t("Animation Settings"));
    $group->dropdown("transition")
      ->label(t("Transition (default: Elastic)"))
      ->options(array("default" => t("Elastic (default)"), "fade" => t("Fade"), "none" => t("None")))
      ->selected($this->read_item_state("transition", "default"));
    $group->checkbox("slideshow_enable")
      ->label(t("Enable Slideshow (Default: off)"))
      ->checked($this->read_item_state("slideshow_enable", FALSE));
    $group->checkbox("slideshow_auto")
      ->label(t("Auto start Slideshow (Default: on)"))
      ->checked(!$this->read_item_state("slideshow_noauto", FALSE));
    $group->input("slideshow_speed")
      ->label(t("Slideshow Speed (default: 2500)"))
      ->rules("required")
      ->error_messages("required", t("You must enter a value"))
      ->value($this->read_item_state("slideshow_speed", "2500"));

    $group = $form->group("g_colorbox_behavior")->label(t("Behavior Settings"));
    $group->checkbox("close_o_click")
      ->label(t("Close on Overlay Click (Default: on)"))
      ->checked(!$this->read_item_state("noCloseOvClick", FALSE));
    $group->checkbox("close_e_click")
      ->label(t("Close with Esc (Default: on)"))
      ->checked(!$this->read_item_state("noCloseEsc", FALSE));
    $group->checkbox("cyclic")
      ->label(t("Cyclic Navigation (Default: on)"))
      ->checked(!$this->read_item_state("noCyclic", FALSE));

    $form->submit("")->value(t("Save"));
    return $form;
  }

  protected function get_edit_form_help() {
    $help = '<fieldset>';
    $help .= '<legend>Help</legend><ul>';
    $help .= '<li><h3>Appearance Settings</h3>
      <p><b>Target (jQuery filter)</b> - specify one or more possible target elements which would be handled by ColorBox
      separated with <b>;</b> delimiter. Default: a.g-sb-preview;a.g-fullsize-link
      <br /><b>Overlay Opacity</b> - Opacity of overlay.
      </li>';
    $help .= '<li><h3>Animation Settings</h3>
      <p><b>Transition</b> - The transition type. Can be set to "elastic", "fade", or "none".
      <br />You can <b>Enable Slideshow</b> and then set <b>Auto start</b> along with <b>Slideshow Speed</b>.
      </li>';
    $help .= '<li><h3>Behavior Settings</h3>
      <p>The following settings should be left on default unless you know what you are doing.
      <br /><b>Close on Overlay Click</b> - Close ColorBox by clicking on the overlay
      <br /><b>Close with Esc</b> - Close ColorBox when "Escape" key is pressed
      </li>';

    $help .= '</ul></fieldset>';
    return t($help);
  }
}

?>