<?php defined("SYSPATH") or die("No direct script access.");
/**
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2009 Bharat Mediratta
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
class Admin_clustrmaps_Controller extends Admin_Controller {

  public function index() {
    $view = new Admin_View("admin.html");
    $view->content = new View("admin_clustrmaps.html");
    $view->content->form = $this->_get_setting_form();
    $view->content->help = $this->_get_help_form();

    print $view;
  }

  public function save() {
    access::verify_csrf();

    $form = $this->_get_setting_form();
    if ($form->validate()) {
      $caption   = $form->configure_clustrmaps->caption->value;
      $html_code = $form->configure_clustrmaps->html_code->value;

    	module::clear_var("clustrmaps", "user_id");
    	module::clear_var("clustrmaps", "site_id");

      $ok = true;
      if (empty($caption)) {
        $form->configure_clustrmaps->caption->add_error("invalid", 1);
        $ok = false;
      } else {
        module::set_var("clustrmaps", "caption", $caption);
      }

      if (empty($html_code)) {
        $form->configure_clustrmaps->html_code->add_error("invalid", 2);
        $ok = false;
      } else {
        module::set_var("clustrmaps", "html_code", $html_code);
      }

      if ($ok) {
        message::success("ClustrMaps 'HTML Code has been Saved.");
        url::redirect("admin/clustrmaps");
			}
    }

    $view = new Admin_View("admin.html");
    $view->content = new View("admin_clustrmaps.html");
    $view->content->form = $form;
    $view->content->help = $this->_get_help_form();
    print $view;
  }

  private function _get_setting_form() {
    $caption = module::get_var("clustrmaps", "caption", "Visitor locations");
    $html_code = module::get_var("clustrmaps", "html_code", "");
    $html_code = str_replace('\\"', '"', $html_code); 
    $html_code = str_replace("\\'", "'", $html_code); 

    $form = new Forge("admin/clustrmaps/save", "", "post", array("id" => "g-admin-configure-clustrmaps-form"));
    $group = $form->group("configure_clustrmaps")->label(t("Settings"));
    $group->input("caption")->label(t("Block Caption"))->value($caption);
    $group->caption->error_messages("invalid", t("Caption cannot be empty."));
    $group->textarea("html_code")->label(t("'HTML Code' provided by Clustrmaps"))->value($html_code);
    $group->html_code->error_messages("invalid", t("'HTML Code' cannot be empty."));
    $group->submit("")->value(t("Save"));
    return $form;
  }

  private function _get_help_form() {
    $help  = '<fieldset>';
    $help .= '<legend>Help</legend><br />';
    $help .= "<p>" . t("Insert 'HTML Code' provided during registration below.") . "</p>";
    $help .= '</fieldset>';
    return $help;
  }
}
